# encoding: utf-8

# Copyright Peter Nowell

from __future__ import division, print_function, unicode_literals
import objc
from GlyphsApp import *
from GlyphsApp.plugins import *
import traceback

fallbackCompanionPluginName = 'Font Proofer Companion'

class FontProoferCompanionPlugin(GeneralPlugin):

	@objc.python_method
	def settings(self):
		self.name = fallbackCompanionPluginName

	@objc.python_method
	def start(self):	
		try :
			import platform,sys,os
			sys.path.insert(0,os.path.join(os.path.join(os.path.dirname(os.path.realpath(__file__)),'fpcompanion/versions'),{'arm':'arm64','i386':'x86_64'}[platform.processor()]+"_"+(str(sys.version_info[0])+str(sys.version_info[1]))))
		except :
			print( f'{fallbackCompanionPluginName} had some trouble starting up :(' )
			try :
				print( traceback.format_exc() )
			except :
				print("—")
		
		try :
			from fpcompanion import companion
		except :
			print( f'{fallbackCompanionPluginName} had some trouble loading :(' )
			try :
				print( traceback.format_exc() )
			except :
				print("—")
		
		try :
			fpcInstance = companion.FontProoferCompanion()
			fpcInstance.start()
		except :
			print( f'{fallbackCompanionPluginName} had some trouble starting :(' )
			try :
				print( traceback.format_exc() )
			except :
				print("—")

	@objc.python_method
	def __file__(self):
		"""Please leave this method unchanged"""
		return __file__
